/************************************************************************
 * NAME:	fs-trs80
 *
 * DESCR:	Implements the "TRS80" filesystem, which takes care of
 *		many OS's that run on the thing.  The different flavors
 *		(when needed) call these routines with flags.
 *
 *
 * NOTES:	
 ************************************************************************/

#include "fs-trs8034.h"

/************************************************************************
 * NAME:	fs_trs8034_description()
 *
 * DESCR:	Returns a string describing (briefly) this filesystem.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
char *
fs_trs8034_description(void)
{
    return("TRS-80 Model III/IV - DD");
}

/************************************************************************
 * NAME:	fs_trs8034_init() & fs_trs8034_cleanup()
 *
 * DESCR:	Just calls the generic TRS80 stuff.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_trs8034_init(struct floppy *floppy, struct fs_trs8034 *fs)
{
    return(fs_trs80_init(floppy, (struct fs_trs80 *)fs));
}

int
fs_trs8034_cleanup(struct fs_trs8034 *fs)
{
    return(fs_trs80_cleanup((struct fs_trs80 *)fs));
}

/************************************************************************
 * NAME:	fs_trs8034_add()
 *
 * DESCR:	Just calls the generic trs80 stuff.
 *
 * ARGS:
 *
 * RETURNS:
 *
 * NOTES:	
 ************************************************************************/
int
fs_trs8034_add(struct fs_trs8034 *fs, char *name, int fd)
{
    return(fs_trs80_add((struct fs_trs80 *)fs,name,fd));
}

/************************************************************************
 * NAME:	fs_trs8034_del()
 *
 * DESCR:	calls the generic trs80 stuff
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:
 ************************************************************************/
int
fs_trs8034_del(struct fs_trs8034 *fs, char *name)
{
    return(fs_trs80_del((struct fs_trs80 *)fs,name));
}

/************************************************************************
 * NAME:	fs_trs8034_report()
 *
 * DESCR:	just calls the generic trs-80 stuff
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_trs8034_report(struct fs_trs8034 *fs, int verbosity)
{
    return(fs_trs80_report((struct fs_trs80 *)fs,verbosity));
}

/************************************************************************
 * NAME:	fs_trs8034_extract()
 *
 * DESCR:	calls the generic trs80 stuff
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_trs8034_extract(struct fs_trs8034 *fs, char *name, int fd)
{
    return(fs_trs80_extract((struct fs_trs80 *)fs,name,fd));
}

/************************************************************************
 * NAME:	fs_trs8034_compress()
 *
 * DESCR:	calls the generic trs80 stuff
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_trs8034_compress(struct fs_trs8034 *fs)
{
    return(fs_trs80_compress((struct fs_trs80 *)fs));
}
